<?php
	/**
		* Template part for displaying posts
		*
		* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
		*
		* @package LogicalBiological
	*/
	
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php // logicalbiological_post_thumbnail(); ?>
	<div class="boxed-width normal_padding">
		<div class="row">
			<div class="col width3of4 post_content">
				<div class="entry-content simple_text">
					<?php
						the_content(
						sprintf(
						wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'logicalbiological' ),
						array(
						'span' => array(
						'class' => array(),
						),
						)
						),
						wp_kses_post( get_the_title() )
						)
						);
					?>
				</div>
				<div class="subscribe-content simple_text">
					<h4>
						Want to hear more from Logical Biological? 
					</h4>
					<p>
						Sign up to our newsletter to for the latest updates.
					</p>
					<a class="rounded_button yellow" href="/newsletter-sign-up/">
						<span>Subscribe Now</span>
					</a>
				</div>
			</div>
			<div class="col width1of4 post_sidebar">
				<div class="post_sidebar_content">
				<h4>
					Blog Overview
				</h4>
				<div class="post_date">
					<i class="fa-solid fa-calendar-days"></i><? echo get_the_time('F jS Y'); ?>
				</div>
				<div class="category_and_tags">
					<? foreach((get_the_category($recentpostID)) as $tag){
						echo '<a class="cat_tag blue" href="/blog/?_category='.$tag->slug.'">'.$tag->name.'</a>'.' ';
					} ?>
				</div>
				<div class="post_sharing">
					<h5>
						Share this blog:
					</h5>
					<div class="sharing_icons">
						<?php	$postUrl = 'http' . ( isset( $_SERVER['HTTPS'] ) ? 's' : '' ) . '://' . "{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}"; ?>
						<a target="_blank" class="share-button share-twitter" href="https://twitter.com/intent/tweet?url=<?php echo $postUrl; ?>&text=<?php echo the_title(); ?>&via=<?php the_author_meta( 'twitter' ); ?>" title="Tweet this"><i class="fa-brands fa-x-twitter"></i></a>
						<a target="_blank" class="share-button share-linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo $postUrl; ?>&title=<? ?>&source=ostmarketing.com" title="Linkedin this"><i class="fab fa-linkedin-in"></i></a>
						<a target="_blank" class="share-button share-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $postUrl; ?>" title="Share on Facebook"><i class="fab fa-facebook-f"></i></a>
						<? /* <a href="https://www.instagram.com/?url=<?php echo $postUrl; ?>" target="_blank" rel="noopener"><i class="fab fa-instagram"></i></a> */ ?>
						<? /* <a href="https://api.whatsapp.com/send?text=<?php echo $postUrl; ?>" data-action="share/whatsapp/share" target="_blank"><i class="fab fa-whatsapp"></i></a> */ ?>
						<? /* a href="https://www.tumblr.com/widgets/share/tool?shareSource=legacy&canonicalUrl=<?php echo $postUrl; ?>&posttype=link" target="_blank"><i class="fab fa-tumblr"></i></a>
						<a href="//pinterest.com/pin/create/link/?url=<?php echo $postUrl; ?>"><i class="fab fa-pinterest-p"></i></a> */ ?>
						<a target="_blank" href="mailto:?subject=I wanted you to see this site&amp;body=Check out this post: <?php echo $postUrl; ?>" class="share-button share-email"  title="Share by Email">  <i class="fas fa-envelope"></i></a>
						<? /* <a class="share-button share-link" title="Copy link" onclick="CopyUrlToClipboard();"><i class="fas fa-link"></i><div id="tooltip">Copied to clipboard</div> </a> */ ?>
					</div>
					<script>
						function showTooltip() {
							document.getElementById("tooltip").classList.add("active");
							setTimeout(
							function() {
								document.getElementById('tooltip').classList.remove("active")
							}, 1000);
						}	
						function CopyUrlToClipboard() {
							navigator.clipboard.writeText(window.location.href);
							showTooltip();
						}
					</script>
				</div>
				<div class="buttons_container">
					<? $primary_cat = get_primary_taxonomy_term(); ?> 
					<? $custom_category_link = '';
						if (get_field('post_category_links', 'options')) {
							if (have_rows('post_category_links', 'options')) {
								while (have_rows('post_category_links', 'options')) {
									the_row();
									if((get_sub_field('category'))==$primary_cat['name']) {
										$custom_category_link = get_sub_field('link');
									}
								}
							}
						} ?>
						<a class="rounded_button yellow" href="<?php if($custom_category_link!='') {
							echo $custom_category_link; 
						} else { echo '/blog/?_category='.$primary_cat['slug']; } ?>">
						<span><? echo $primary_cat['name']; ?></span>
						</a>
						<a class="rounded_button yellow" href="/contact/">
							<span>Contact Us</span>
						</a>
				</div>
				<div class="related_posts">
					<h4>Related Blogs</h4>
					<? $categories = get_category_by_slug($primary_cat['slug'])->term_id;
						
						global $wp_query;
						$original_query = $wp_query;
						$wp_query = null;
						
						$args = array(
						"post_type" => [
						"post"
						],
						"post_status" => [
						"publish"
						],
						"post__not_in" => array (get_the_ID()),
						"orderby" => [
						"date" => "DESC"
						],
						"cat"      => array($categories),	
						"posts_per_page" => 1
						);	
						$wp_query = new WP_Query( $args );
						if ( have_posts() ) { ?>
						<div class="all_posts featured3">
							<? while ( have_posts() ) { the_post(); ?>
								<? $recentpost = get_post( get_the_ID() ); $recentpostID = get_the_ID(); ?>
								<div class="single_featured_card">
									<div class="single_featured_details">
										<div class="category_and_tags">
											
											<? foreach((get_the_category($recentpostID)) as $tag){
												echo '<a class="cat_tag blue" href="/blog/?_category='.$tag->slug.'">'.$tag->name.'</a>'.' ';
											} ?>
										</div>
										<div class="single_b_title">
											<? $this_link = get_permalink($recentpostID); ?>
											<a href="<? echo $this_link; ?>" target="_self"><h4><?php echo get_the_title($recentpostID); ?></h4></a>
										</div>
										<div class="single_b_date">
											<? echo get_the_time('F jS Y', $recentpostID); ?>
										</div>
										<div class="single_b_excerpt">
											<?php 
												
												$excerpt = $recentpost->post_excerpt;
												
												echo strip_tags(html_entity_decode($excerpt));
											?>
										</div>
										<div class="single_b_link">
											<a class="rounded_button yellow" href="<?php echo get_permalink($recentpostID);; ?>">
												<span>Read More</span>
											</a>
											
										</div>
									</div>
									<a class="single_featured_image" href="<?php echo get_permalink($recentpostID);; ?>">
										<img alt="<? if (get_post_meta( get_post_thumbnail_id( $recentpostID ), '_wp_attachment_image_alt', true)) {
											echo get_post_meta( get_post_thumbnail_id( $recentpostID ), '_wp_attachment_image_alt', true);
											} else {
											if (get_the_title( get_post_thumbnail_id( $recentpostID ) )) {
												echo get_the_title( get_post_thumbnail_id( $recentpostID ));
											} else echo 'featured-image';
										} ?>" src="<?php 
										if (get_the_post_thumbnail( $recentpostID, 'large' )!=null) {
											
										echo get_the_post_thumbnail_url( $recentpostID, 'large' ); }
										else echo '/wp-content/uploads/2023/09/placeholder.jpg'; ?>)">
									</a>
								</div>
							<?	} ?>
						</div>	
						<? }
						$wp_query = null;
						$wp_query = $original_query;
					wp_reset_postdata(); ?>	
					
				</div>
				</div>
			</div>
		</div><!-- .entry-content -->
	</div>
	<footer class="entry-footer">
		<?php //logicalbiological_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
