<?php
	/**
		* LogicalBiological functions and definitions
		*
		* @link https://developer.wordpress.org/themes/basics/theme-functions/
		*
		* @package LogicalBiological
	*/
	
	if ( ! defined( '_S_VERSION' ) ) {
		// Replace the version number of the theme on each release.
		define( '_S_VERSION', '1.0.0' );
	}
	
	/**
		* Sets up theme defaults and registers support for various WordPress features.
		*
		* Note that this function is hooked into the after_setup_theme hook, which
		* runs before the init hook. The init hook is too late for some features, such
		* as indicating support for post thumbnails.
	*/
	function logicalbiological_setup() {
		/*
			* Make theme available for translation.
			* Translations can be filed in the /languages/ directory.
			* If you're building a theme based on LogicalBiological, use a find and replace
			* to change 'logicalbiological' to the name of your theme in all the template files.
		*/
		load_theme_textdomain( 'logicalbiological', get_template_directory() . '/languages' );
		
		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		
		/*
			* Let WordPress manage the document title.
			* By adding theme support, we declare that this theme does not use a
			* hard-coded <title> tag in the document head, and expect WordPress to
			* provide it for us.
		*/
		add_theme_support( 'title-tag' );
		
		/*
			* Enable support for Post Thumbnails on posts and pages.
			*
			* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
		add_theme_support( 'post-thumbnails' );
		
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
		array(
		'menu-1' => esc_html__( 'Primary', 'logicalbiological' ),
		)
		);
		
		/*
			* Switch default core markup for search form, comment form, and comments
			* to output valid HTML5.
		*/
		add_theme_support(
		'html5',
		array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
		'style',
		'script',
		)
		);
		
		// Set up the WordPress core custom background feature.
		add_theme_support(
		'custom-background',
		apply_filters(
		'logicalbiological_custom_background_args',
		array(
		'default-color' => 'ffffff',
		'default-image' => '',
		)
		)
		);
		
		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
		
		/**
			* Add support for core custom logo.
			*
			* @link https://codex.wordpress.org/Theme_Logo
		*/
		add_theme_support(
		'custom-logo',
		array(
		'height'      => 250,
		'width'       => 250,
		'flex-width'  => true,
		'flex-height' => true,
		)
		);
	}
	add_action( 'after_setup_theme', 'logicalbiological_setup' );
	
	/**
		* Set the content width in pixels, based on the theme's design and stylesheet.
		*
		* Priority 0 to make it available to lower priority callbacks.
		*
		* @global int $content_width
	*/
	function logicalbiological_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'logicalbiological_content_width', 640 );
	}
	add_action( 'after_setup_theme', 'logicalbiological_content_width', 0 );
	
	/**
		* Register widget area.
		*
		* @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
	*/
	function logicalbiological_widgets_init() {
		register_sidebar(
		array(
		'name'          => esc_html__( 'Sidebar', 'logicalbiological' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'logicalbiological' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
		)
		);
	}
	add_action( 'widgets_init', 'logicalbiological_widgets_init' );
	
	/**
		* Enqueue scripts and styles.
	*/
	function logicalbiological_scripts() {
		wp_enqueue_style( 'logicalbiological-style', get_stylesheet_uri(), array(), _S_VERSION );
		wp_style_add_data( 'logicalbiological-style', 'rtl', 'replace' );
		
		wp_enqueue_script( 'logicalbiological-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );
		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
	add_action( 'wp_enqueue_scripts', 'logicalbiological_scripts' );
	
	/**
		* Implement the Custom Header feature.
	*/
	require get_template_directory() . '/inc/custom-header.php';
	
	/**
		* Custom template tags for this theme.
	*/
	require get_template_directory() . '/inc/template-tags.php';
	
	/**
		* Functions which enhance the theme by hooking into WordPress.
	*/
	require get_template_directory() . '/inc/template-functions.php';
	
	/**
		* Customizer additions.
	*/
	require get_template_directory() . '/inc/customizer.php';
	
	
	// linebreak shortcode
	
	function line_break_shortcode_callback() {
		return '<br>';
	}
	add_shortcode( 'br', 'line_break_shortcode_callback' );
	
function LocationIcon() {
		return '<i class="fa-solid fa-location-dot"></i>';
	}
	add_shortcode( 'location-icon', 'LocationIcon' );

function MailIcon() {
		return '<i class="fa-solid fa-envelope"></i>';
	}
	add_shortcode( 'mail-icon', 'MailIcon' );

function PhoneIcon() {
		return '<i class="fa-solid fa-phone"></i>';
	}
	add_shortcode( 'phone-icon', 'PhoneIcon' );


	/**
		* Load Jetpack compatibility file.
	*/
	if ( defined( 'JETPACK__VERSION' ) ) {
		require get_template_directory() . '/inc/jetpack.php';
	}
	
	//remove default page editor for pages
	
	add_action('init', 'remove_default_page_editor',100);
	function remove_default_page_editor(){
		$post_type = 'page';
		remove_post_type_support( $post_type, 'editor');
	}
	
	
	// This will suppress empty email errors when submitting the user form
	add_action('user_profile_update_errors', 'my_user_profile_update_errors', 10, 3 );
	function my_user_profile_update_errors($errors, $update, $user) {
		$errors->remove('empty_email');
	}
	
	// This will remove javascript required validation for email input
	// It will also remove the '(required)' text in the label
	// Works for new user, user profile and edit user forms
	add_action('user_new_form', 'my_user_new_form', 10, 1);
	add_action('show_user_profile', 'my_user_new_form', 10, 1);
	add_action('edit_user_profile', 'my_user_new_form', 10, 1);
	function my_user_new_form($form_type) {
	?>
	<script type="text/javascript">
		jQuery('#email').closest('tr').removeClass('form-required').find('.description').remove();
		// Uncheck send new user email option by default
		<?php if (isset($form_type) && $form_type === 'add-new-user') : ?>
		jQuery('#send_user_notification').removeAttr('checked');
		<?php endif; ?>
	</script>
	<?php
	}
	
	add_action('admin_head', 'admin_css');
	
	function admin_css() {
		echo '<style>
		.acf-field[data-name="col"] {
		background: rgba(0,0,0,0.1);
		}
		.acf-field[data-name="col"] > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row{
		display: inline-block; 
		vertical-align: top;}
		.acf-field[data-name="col"] > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row:has(label.selected input[value="1of1"]) {
		width: 100%!important;
		}
		.acf-field[data-name="col"] > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row:has(label.selected input[value="1of2"]) {
		width: 50%!important;
		}
		.acf-field[data-name="col"] > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row:has(label.selected input[value="1of3"]) {
		width: 33%!important;
		}
		.acf-field[data-name="col"] > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row:has(label.selected input[value="2of3"]) {
		width: 66%!important;
		}
		.acf-field[data-name="col"] > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row:has(label.selected input[value="1of4"]) {
		width: 25%!important;
		}
		.acf-field[data-name="col"] > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row:has(label.selected input[value="3of4"]) {
		width: 75%!important;
		}
		
		.acf-field[data-name="col"] > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row td.acf-fields {
		width: 100%;
		}
		
		.acfe-modal {
		margin-left: 0!important;
		}
		
		.acf-input select option {
		padding: 10px;
		}
		//   .acf-input select option:hover {
		//   background: none!important;
		//   }
		//   .acf-input select option[value="yellow"] {
		//   background: #F7A720;
		//   color: #000;
		//   }
		//    .acf-input select option[value="blue"] {
		//   background: #27ADE4;
		//   color: #000;
		//   }
		//   .acf-input select option[value="light_blue"] {
		//   background: #27ADE4;
		//   color: #000;
		//   }
		//    .acf-input select option[value="dark_blue"] {
		//   background: #112847;
		//   color: #fff;
		//   }
		//    .acf-input select option[value="grey"] {
		//   background: #efefef;
		//   color: #000;
		//   }
		//    .acf-input select option[value="white"] {
		//   background: #fff;
		//   color: #000;
		//   }
		
		</style>';
	}
	
	// Add custom colors to wysywig editor
	
	function my_mce4_options($init) {
		
		$custom_colours = '
        "F7A720", "yellow",
        "27ADE4", "blue",
        "112847", "darkblue",
        "efefef", "grey",
        "000", "black",
		"FFF", "white"
		';
		
		// build colour grid default+custom colors
		$init['textcolor_map'] = '['.$custom_colours.']';
		
		// change the number of rows in the grid if the number of colors changes
		// 8 swatches per row
		$init['textcolor_rows'] = 1;
		
		return $init;
	}
	add_filter('tiny_mce_before_init', 'my_mce4_options');
	
	function ProductsSearch() { 
	ob_start(); ?>
	
	<form action="/human-biospecimens/#products_search" method="get">
		<div class="title_search">
			<div class="placeholder" id="productstringplaceholder">
				Search Our Products
			</div>
			<input type="text" id="productstring" name="_search" onfocus="ActivatePlaceholder(this);" onfocusout="DeactivatePlaceholder(this)">
			<input type="submit" value="Search">
		</div>
	</form>
	<script>
		function ActivatePlaceholder(elem) {
			elem.parentNode.querySelector(".placeholder").classList.add("active");
// 			var myPlaceholder = document.querySelectorAll(X);
// 			for (var i=0; i<myPlaceholder.length; i++) {
// 			myPlaceholder[i].classList.add("active");
// 			}
		}
		function DeactivatePlaceholder(elem) {
			if (elem.value == "") {
				elem.parentNode.querySelector(".placeholder").classList.remove("active");
			}
		}
		function LowercaseThis(elem) {
			elem.value = elem.value.toLowerCase();
		}
	</script>
	
	<? return ob_get_clean();
	}
	add_shortcode('products-search', 'ProductsSearch');

	function SiteSearch() { 
	ob_start(); ?>
	
	<form action="/search/" method="get">
		<div class="title_search">
			<div class="placeholder" id="productstringplaceholder">
				Search
			</div>
			<input type="text" id="productstring" name="_string" onfocus="ActivatePlaceholder(this);" onfocusout="DeactivatePlaceholder(this)">
			
			<input type="submit" value="Search">
		</div>
	</form>
	<script>
		function ActivatePlaceholder(elem) {
			elem.parentNode.querySelector(".placeholder").classList.add("active");
		}
		function DeactivatePlaceholder(elem) {
			if (elem.value == "") {
				elem.parentNode.querySelector(".placeholder").classList.remove("active");
			}
		}
		function LowercaseThis(elem) {
			elem.value = elem.value.toLowerCase();
		}
	</script>
	
	<? return ob_get_clean();
	}
	add_shortcode('site-search', 'SiteSearch');
	
	function All_Products() { 
	ob_start(); ?>
	<div class="products_search" id="products_search">
		<div class="fitler_toggle">
			<button class="togle_title" data-startingname="Disease Category" onclick="ToggleFilter(this);">Disease Category</button>
	  		<? echo do_shortcode('[facetwp facet="product_category"]'); ?>
		</div>
		<div class="fitler_toggle">
			<button class="togle_title" data-startingname="Matrix" onclick="ToggleFilter(this);">Matrix</button>
			<? echo do_shortcode('[facetwp facet="matrix"]'); ?>
		</div>
		<div class="search_filter">
			<? echo do_shortcode('[facetwp facet="search"]'); ?> 
		</div>
		<div class="reset_filters">
			<? echo do_shortcode('[facetwp facet="reset"]'); ?> 
		</div>
	</div>
	<div class="products_listing">
		<? echo do_shortcode('[facetwp template="products"]'); ?>
	</div>
	<div class="product_pagination">
		<? echo do_shortcode('[facetwp facet="count"]'); ?>
		<? echo do_shortcode('[facetwp facet="pagination"]'); ?>
	</div>
	<script>
		function ToggleFilter(elem) {
			elem.parentElement.querySelector(".facetwp-facet").classList.toggle("active");
			elem.classList.toggle("active");
			var howManyAreSelected = elem.parentElement.querySelector(".facetwp-facet").querySelectorAll(".facetwp-checkbox.checked");
			if (howManyAreSelected.length > 0) {
				elem.innerHTML = howManyAreSelected.length+" selected";
				}  else {
				elem.innerHTML = elem.dataset.startingname;
			}
			
		}
		const product_filters = document.querySelector('.products_search');
		
		document.addEventListener('click', event => {
			const isClickInside = product_filters.contains(event.target);
			
			if (!isClickInside) {
				var allFilters = document.querySelectorAll(".togle_title");
				for (var i=0; i<allFilters.length; i++ ){
					allFilters[i].parentElement.querySelector(".facetwp-facet").classList.remove("active");
					allFilters[i].classList.remove("active");
					var howManyAreSelected = allFilters[i].parentElement.querySelector(".facetwp-facet").querySelectorAll(".facetwp-checkbox.checked");
					if (howManyAreSelected.length > 0) {
						allFilters[i].innerHTML = howManyAreSelected.length+" selected";
						}  else {
						allFilters[i].innerHTML = allFilters[i].dataset.startingname; 
					}
				}
			}
		})	
	</script>
	<script> //change reset button
		document.addEventListener("DOMContentLoaded", (event) => {
  
		var ResetButton = document.querySelector(".facetwp-reset");
		
			ResetButton.innerHTML = '<i class="fa-solid fa-xmark"></i>';
});
			
	</script>
	<? return ob_get_clean();
	}
	add_shortcode('all-products', 'All_Products');

	function All_Blogs() { 
	ob_start(); ?>
	<div class="products_search">
		<div class="fitler_toggle">
			<button class="togle_title" data-startingname="Year" onclick="ToggleFilter(this);">Year</button>
			<? echo do_shortcode('[facetwp facet="year"]'); ?>
		</div>
		<div class="fitler_toggle">
			<button class="togle_title" data-startingname="Category" onclick="ToggleFilter(this);">Category</button>
	  		<? echo do_shortcode('[facetwp facet="category"]'); ?>
		</div>
		<div class="search_filter">
			<? echo do_shortcode('[facetwp facet="search"]'); ?> 
		</div>
		<div class="reset_filters">
			<? echo do_shortcode('[facetwp facet="reset"]'); ?> 
		</div>
	</div>
	<div class="blog_listing">
		<? echo do_shortcode('[facetwp template="blog"]'); ?>
	</div>
	<div class="product_pagination blog_pagination">
		<? echo do_shortcode('[facetwp facet="pagination"]'); ?>
	</div>
	<script>
		function ToggleFilter(elem) {
			elem.parentElement.querySelector(".facetwp-facet").classList.toggle("active");
			elem.classList.toggle("active");
			var howManyAreSelected = elem.parentElement.querySelector(".facetwp-facet").querySelectorAll(".facetwp-checkbox.checked");
			if (howManyAreSelected.length > 0) {
				elem.innerHTML = howManyAreSelected.length+" selected";
				}  else {
				elem.innerHTML = elem.dataset.startingname;
			}
			
		}
		const product_filters = document.querySelector('.products_search');
		
		document.addEventListener('click', event => {
			const isClickInside = product_filters.contains(event.target);
			
			if (!isClickInside) {
				var allFilters = document.querySelectorAll(".togle_title");
				for (var i=0; i<allFilters.length; i++ ){
					allFilters[i].parentElement.querySelector(".facetwp-facet").classList.remove("active");
					allFilters[i].classList.remove("active");
					var howManyAreSelected = allFilters[i].parentElement.querySelector(".facetwp-facet").querySelectorAll(".facetwp-checkbox.checked");
					if (howManyAreSelected.length > 0) {
						allFilters[i].innerHTML = howManyAreSelected.length+" selected";
						}  else {
						allFilters[i].innerHTML = allFilters[i].dataset.startingname; 
					}
				}
			}
		})	
	</script>
	<? return ob_get_clean();
	}
	add_shortcode('all-blogs', 'All_Blogs');

	function CustomSearch() { 
	ob_start(); ?>
	<div class="products_search">
		<div class="search_filter">
			<? echo do_shortcode('[facetwp facet="string"]'); ?> 
		</div>
	</div>
	<div class="blog_listing">
		<? echo do_shortcode('[facetwp template="custom_search"]'); ?>
	</div>
	<div class="product_pagination blog_pagination">
		<? echo do_shortcode('[facetwp facet="pagination"]'); ?>
	</div>
	<? return ob_get_clean();
	}
	add_shortcode('search-results', 'CustomSearch');

	function LBmap() { 
	ob_start(); ?>
 <div id="map" class="lb_map"></div>
    <script
      src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCWPIReHwWzwxDWv_ndlNtPaNqgDPLo8as&callback=initMap&v=weekly"
      defer
    ></script>
<script>
let map;

function initMap() {
  map = new google.maps.Map(document.getElementById("map"), {
    center: new google.maps.LatLng(51.28740690041728, 1.342557225886779),
    zoom: 8,
  });

  const iconBase =
    "/wp-content/themes/logicalbiological/images/";
  const icons = {
    info: {
      icon: iconBase + "map_pin.svg",
    },
  };
  const features = [
    {
      position: new google.maps.LatLng(51.28740690041728, 1.342557225886779),
      type: "info",
    },
  ];

  // Create markers.
  for (let i = 0; i < features.length; i++) {
    const marker = new google.maps.Marker({
      position: features[i].position,
      icon: icons[features[i].type].icon,
      map: map,
    });
  }
}

window.initMap = initMap;

</script>
	<? return ob_get_clean();
	}
	add_shortcode('lb-map', 'LBmap');

/**
 * Change date filter to year only
 */
add_filter( 'facetwp_index_row', function( $params, $class ) {
	if ( 'year' == $params['facet_name'] ) { // change 'year' to name of your facet
		$raw_value = $params['facet_value'];
		$params['facet_value'] = date( 'Y', strtotime( $raw_value ) );
		$params['facet_display_value'] = $params['facet_value'];
	}
	return $params;
}, 10, 2 );

/**
 * Returns the primary term for the chosen taxonomy set by Yoast SEO
 * or the first term selected.
 *
 * @link https://www.tannerrecord.com/how-to-get-yoasts-primary-category/
 * @param integer $post The post id.
 * @param string  $taxonomy The taxonomy to query. Defaults to category.
 * @return array The term with keys of 'name', 'slug', and 'url'.
 */
function get_primary_taxonomy_term( $post = 0, $taxonomy = 'category' ) {
	if ( ! $post ) {
		$post = get_the_ID();
	}

	$terms        = get_the_terms( $post, $taxonomy );
	$primary_term = array();

	if ( $terms ) {
		$term_display = '';
		$term_slug    = '';
		$term_link    = '';
		if ( class_exists( 'WPSEO_Primary_Term' ) ) {
			$wpseo_primary_term = new WPSEO_Primary_Term( $taxonomy, $post );
			$wpseo_primary_term = $wpseo_primary_term->get_primary_term();
			$term               = get_term( $wpseo_primary_term );
			if ( is_wp_error( $term ) ) {
				$term_display = $terms[0]->name;
				$term_slug    = $terms[0]->slug;
				$term_link    = get_term_link( $terms[0]->term_id );
			} else {
				$term_display = $term->name;
				$term_slug    = $term->slug;
				$term_link    = get_term_link( $term->term_id );
			}
		} else {
			$term_display = $terms[0]->name;
			$term_slug    = $terms[0]->slug;
			$term_link    = get_term_link( $terms[0]->term_id );
		}
		$primary_term['url']   = $term_link;
		$primary_term['slug']  = $term_slug;
		$primary_term['name'] = $term_display;
	}
	return $primary_term;
}


  // Function to remove Special Characters From String
  function RemoveSpecialChar($str) {
 
      // Using str_replace() function 
      // to replace the word 
      $res = str_replace( array( '\'', '"',
      ',' , ';', '<', '>', ' ' ), '', $str);
 
      // Returning the result 
      return $res;
}

function DDSignature() { 
ob_start(); ?>
  <?php global $wp;  
$current_url = home_url(add_query_arg(array($_GET), $wp->request));
if ($current_url==get_site_url()) { ?>
	<div style="display: flex; align-items: center; gap: 12px; color: #fff; padding: 26px 0;">
		<a href="https://linktr.ee/douglassdigital" target="_blank" rel="noopener noreferrer">Web Design by</a> Douglass Digital
	</div>
	<?php } else { ?>
	<div style="display: flex; align-items: center; gap: 12px; color: #fff; padding: 26px 0;">
		<a href="https://linktr.ee/douglassdigital" target="_blank" rel="noopener noreferrer">Web Design by</a> Douglass Digital
	</div>
			<?php } ?> 
<? return ob_get_clean();
}
add_shortcode('DD-signature', 'DDSignature');