<?php
/**
 * Genesis icon encoded for use as a top-level menu item in `add_admin_menu()`.
 *
 * This process ensures the WP admin area correctly styles the icon for active
 * and hover state colors relating to the user's active admin theme. No further
 * custom CSS is required.
 *
 * Based on the original genesis-icon.svg from this directory.
 *
 * If modifying, ensure that:
 *   - The `style="fill:currentColor"` attribute is retained on the svg.
 *   - The width attribute of the svg is about 20.
 *   - The path has a `fill="#9ea3a9"` attribute to prevent a flash of black.
 *
 * Base64 encode the resulting icon. The “Data URI” output format here works:
 * https://base64.guru/converter/encode/image/svg.
 *
 * @package Genesis\Blocks\Settings
 * @since   1.0.0
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://github.com/studiopress/genesis-blocks/
 */

return <<<icon
data:image/svg+xml;base64,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
icon;
